/*
 * @Author: zhoufei
 * @Date: 2022-05-19 16:05:49
 * @LastEditors: zhoufei
 * @LastEditTime: 2022-05-26 10:29:58
 * @FilePath: /utils/map_g_test.go
 * @Description:
 *
 * Copyright (c) 2022 by zhoufei, All Rights Reserved.
 */
package utils

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestMapG(t *testing.T) {
	m := NewMap[string, string]()
	m.Set("a", "b", 0)
	b, _ := m.Get("a")
	assert.Equal(t, b, "b")
}

func TestMapClone(t *testing.T) {
	a := NewMap[string, string]()
	a.Set("a", "b", 0)
	bb := NewMap[string, string]()
	a.CloneTo(bb)
	bb.Set("a", "c", 0)
	a.Set("a", "d", 0)

	aa, ok := bb.Get("a")
	assert.Equal(t, true, ok)
	assert.Equal(t, "c", aa)

	aaa, ok := a.Get("a")
	assert.Equal(t, true, ok)
	assert.Equal(t, "d", aaa)

}
