/*
 * @Author: zhoufei
 * @Date: 2022-03-04 14:35:55
 * @LastEditors: zhoufei
 * @LastEditTime: 2022-05-27 09:54:50
 * @FilePath: /utils/mongodb_test.go
 * @Description:
 *
 * Copyright (c) 2022 by zhoufei, All Rights Reserved.
 */
package utils

import (
	"context"
	"testing"

	"github.com/go-playground/assert/v2"
	"go.mongodb.org/mongo-driver/bson"
)

func TestMongo_InitCli(t *testing.T) {

	m, err := NewMongo("192.168.31.129:27017/snc", "snc", "shuoren@2019snc",
		WithDB("snc"), WithCollection("alarm"))
	if err != nil {
		t.Fatal(err)
	}

	defer m.Close()

	c, err := m.Cli.Find(context.Background(), bson.M{}).Count()
	if err != nil {
		t.Fatal(err)
	}
	count := int64(38999)
	assert.Equal(t, c, count)
}

func TestMongo_InitClient(t *testing.T) {
	m, err := NewMongo("192.168.31.129:27017/snc", "snc", "shuoren@2019snc")
	if err != nil {
		t.Fatal(err)
	}
	defer m.Close()

	c, err := m.Client.Database("snc").Collection("alarm").Find(context.Background(), bson.M{}).Count()
	if err != nil {
		t.Fatal(err)
	}
	count := int64(38999)
	assert.Equal(t, c, count)
}
