/*
 * @Author: zhoufei
 * @Date: 2022-04-22 15:00:32
 * @LastEditors: zhoufei
 * @LastEditTime: 2022-05-06 14:34:13
 * @FilePath: /utils/queue/mq.go
 * @Description: 消息队列interface
 *
 * Copyright (c) 2022 by zhoufei, All Rights Reserved.
 */
package queue

type Producer interface {
	SendMsg(topic string, msg []byte, opts ...MsgOption) (qMsg *QueueMsg, err error)
	SendStringMsg(topic string, msg string, opts ...MsgOption) (qMsg *QueueMsg, err error)
	ShutDown() error
}
type Consumer interface {
	RegisterConsumer(topic string, recevieFunc func(qMsg *QueueMsg), opts ...MsgOption) (err error)
	ShutDown() error
}

type QueueMsg struct {
	Topic string                 `json:"topic"`
	Body  []byte                 `json:"body"`
	Info  map[string]interface{} `json:"info"`
	Tag   string                 `json:"tag"`
}

type msgOptions struct {

	//such as "tag1 || tag2 || tag3"
	Tag string
	// just for rocketmq
	// for sql92,example {"a":"20","b":"true"}
	UserProperties map[string]string

	// just for rocketmq
	// example (a > 10 AND a < 100) OR (b IS NOT NULL AND b=TRUE)
	Sql92 string
}

type MsgOption func(*msgOptions)

/**
 * @description:
 * @param {string} tag
 * @return {*}
 */
func WithMsgTag(tag string) MsgOption {
	return func(mo *msgOptions) {
		if tag == "" {
			return
		}
		mo.Tag = tag
	}
}

func WithSql92(sql string) MsgOption {
	return func(mo *msgOptions) {
		if sql == "" {
			return
		}
		mo.Sql92 = sql
	}
}

func WithUserProperties(p map[string]string) MsgOption {
	return func(mo *msgOptions) {
		if p == nil {
			return
		}
		mo.UserProperties = p
	}
}
