/*
 * @Author: zhoufei
 * @Date: 2022-04-24 14:19:58
 * @LastEditors: zhoufei
 * @LastEditTime: 2022-05-05 14:32:59
 * @FilePath: /utils/queue/rocketmq_test.go
 * @Description: rocketmq 测试
 *
 * Copyright (c) 2022 by zhoufei, All Rights Reserved.
 */

package queue

import (
	"fmt"
	"testing"
	"time"

	"github.com/go-playground/assert/v2"
)

func getProducer() (p Producer, err error) {
	return NewRocketMqProducer([]string{"http://39.101.151.217:9876"}, "test", 2)
}

func TestCreateRocketMqProducer(t *testing.T) {
	procucer, err := getProducer()
	if err != nil {
		t.Fatal(err)
	}
	if p, ok := procucer.(*RocketMq); ok {
		p.producer.Shutdown()
	}
}

func TestRocketMqSendMsg(t *testing.T) {
	procucer, err := getProducer()
	if err != nil {
		t.Fatal(err)
	}
	msg, err := procucer.SendMsg("test", []byte("test"))
	if err != nil {
		t.Fatal(err)
	}

	assert.Equal(t, msg.Topic, "test")
	time.Sleep(10 * time.Second)
	err = procucer.ShutDown()
	if err != nil {
		t.Fatal(err)
	}
}

func TestRocketMqProducerWithTag(t *testing.T) {
	producer, err := getProducer()
	if err != nil {
		t.Fatal(err)
	}

	_, err = producer.SendMsg("test", []byte("tag2 test"), WithMsgTag("tag2"))
	if err != nil {
		t.Fatal(err)
	}

	time.Sleep(3 * time.Second)
	err = producer.ShutDown()
	if err != nil {
		t.Fatal(err)
	}
}

func TestRocketMqConsumer(t *testing.T) {
	client, err := NewRocketMqConsumer([]string{"http://39.101.151.217:9876"}, "test")
	if err != nil {
		t.Fatal(err)
	}

	err = client.RegisterConsumer("test", func(qMsg *QueueMsg) {
		fmt.Printf("info:%v\n", qMsg.Info)
	})
	if err != nil {
		t.Fatal(err)
	}

	procucer, err := getProducer()

	if err != nil {
		t.Fatal(err)
	}
	_, err = procucer.SendMsg("test", []byte("test"))
	if err != nil {
		t.Fatal(err)
	}

	time.Sleep(10 * time.Second)
	procucer.ShutDown()
	client.ShutDown()
}

func TestRocketMqConsumerWithTag(t *testing.T) {
	consumer, err := NewRocketMqConsumer([]string{"http://39.101.151.217:9876"}, "test")
	if err != nil {
		t.Fatal(err)
	}

	err = consumer.RegisterConsumer("test", func(qMsg *QueueMsg) {
		fmt.Printf("info:%v\n", qMsg.Body)
	}, WithMsgTag("tag2"))

	if err != nil {
		t.Fatal(err)
	}
	time.Sleep(3 * time.Second)
	consumer.ShutDown()
}

func TestAliRocket(t *testing.T) {
	p, err := NewRocketMqProducer([]string{"http://onsaddr.mq-internet-access.mq-internet.aliyuncs.com:80"}, "test", 2,
		WithRocketAcl("xxxxx", "xxxxxxxx"))
	if err != nil {
		t.Fatal(err)
	}

	data := `{"a":"b"}`
	msg, err := p.SendStringMsg("xxxx", data)
	if err != nil {
		t.Fatal(err)
	}

	fmt.Println(msg.Info["msgId"])

	p.ShutDown()

}
