/*
 * @Author: zhoufei
 * @Date: 2022-06-08 09:54:03
 * @LastEditors: zhoufei
 * @LastEditTime: 2022-06-08 14:22:38
 * @FilePath: /utils/redis_test.go
 * @Description:
 *
 * Copyright (c) 2022 by zhoufei, All Rights Reserved.
 */
package utils

import (
	"context"
	"fmt"
	"testing"

	"github.com/go-redis/redis/v8"
)

func TestRedisLua(t *testing.T) {
	var realData1 = redis.NewScript(`

	local function aa()
		return "5"
	end
	local r = aa()
	-- 获取所有key
local keys = cjson.decode(KEYS[1])
-- 获取所有的数据
local values = cjson.decode(ARGV[1])
for k, v in ipairs(keys) do
	-- 获取redis实时数据
    local rd = redis.call("get", v)

	if rd then
		local rdt = cjson.decode(rd)
		if rdt then
			if (values[v]["time"] > rdt["time"]) then
				if (values[v]["expire"] > 0) then
					redis.call("SET", v, cjson.encode(values[v]),"EX",values[v]["expire"])
				else
					redis.call("SET", v, cjson.encode(values[v]))
				end
				
			end
		end
	else
		
		if (values[v]["expire"] > 0) then
			
			local a = redis.call("SET", v, cjson.encode(values[v]),"EX",values[v]["expire"])
		else
			redis.call("SET", v, cjson.encode(values[v]))
		end
	end
end
return r
`)

	rdb, err := NewRedis("192.168.31.129:6379", "123456", 0)
	if err != nil {
		t.Fatal(err)
	}

	if err := rdb.Client.Ping(context.Background()).Err(); err != nil {
		t.Fatal(err)
	}

	defer rdb.Client.Close()

	testKeys := `["aaaa","bbb"]`
	testValues := `{"aaaa":{"protoCode":"aaaa","param":"tn","time":223456789,"value":12.5,"expire":0},"bbb":{"protoCode":"bbb","param":"tn","time":243456789,"value":12.5,"expire":10}}`

	r, err := realData1.Run(context.Background(), rdb.Client, []string{testKeys}, testValues).Result()
	fmt.Println("11111")
	// rmd, err := realData.Run(context.Background(), rdb.Client, []string{}).Result()
	if err != nil {
		t.Fatal(err)
	}
	fmt.Println(r)

}
