/*
 * @Author: zhoufei
 * @Date: 2022-05-25 13:54:05
 * @LastEditors: zhoufei
 * @LastEditTime: 2022-06-08 17:02:04
 * @FilePath: /utils/slice.go
 * @Description:
 *
 * Copyright (c) 2022 by zhoufei, All Rights Reserved.
 */
package utils

import "reflect"

func SliceIsContain[T any](array []T, value T) (index int, ok bool) {
	for i, v := range array {
		if reflect.DeepEqual(v, value) {
			return i, true
		}
	}
	return -1, false
}

func Reverse(s string) string {
	bs := []byte(s)
	length := len(bs)
	for i := 0; i < length/2; i++ {
		bs[i], bs[length-i-1] = bs[length-i-1], bs[i]
	}
	return string(bs)
}

func SliceDel[T comparable](array []T, values ...T) []T {
	if len(values) == 0 {
		return array
	}
	m := make(map[T]struct{})
	for _, v := range values {
		m[v] = struct{}{}
	}
	res := make([]T, 0, len(array))
	for _, v := range array {
		if _, ok := m[v]; !ok {
			res = append(res, v)
		}
	}
	return res
}
