/*
 * @Author: zhoufei
 * @Date: 2022-05-25 14:41:48
 * @LastEditors: zhoufei
 * @LastEditTime: 2022-06-08 17:21:39
 * @FilePath: /utils/slice_test.go
 * @Description:
 *
 * Copyright (c) 2022 by zhoufei, All Rights Reserved.
 */
package utils

import (
	"testing"
	"unicode/utf8"

	"github.com/stretchr/testify/assert"
)

func TestSliceIsContain(t *testing.T) {
	_, isContain := SliceIsContain([]string{"a", "b", "c"}, "a")
	assert.Equal(t, true, isContain)
}

func TestSliceDel(t *testing.T) {
	assert.Equal(t, []string{"a", "b"}, SliceDel([]string{"a", "b", "c"}, "c"))
	assert.Equal(t, []string{"a", "b", "c"}, SliceDel([]string{"a", "b", "c"}))
}

func FuzzReverse(f *testing.F) {
	str_slice := []string{"abc", "bb"}
	for _, v := range str_slice {
		f.Add(v)
	}
	f.Fuzz(func(t *testing.T, str string) {
		rev_str1 := Reverse(str)
		rev_str2 := Reverse(rev_str1)
		if str != rev_str2 {
			t.Errorf("fuzz test failed. str:%s, rev_str1:%s, rev_str2:%s", str, rev_str1, rev_str2)
		}
		if utf8.ValidString(str) && !utf8.ValidString(rev_str1) {
			t.Errorf("reverse result is not utf8. str:%s, len: %d, rev_str1:%s", str, len(str), rev_str1)
		}
	})
}
