/*
 * @Author: zhoufei
 * @Date: 2022-06-01 15:20:40
 * @LastEditors: zhoufei
 * @LastEditTime: 2022-06-01 15:27:22
 * @FilePath: /utils/some_test.go
 * @Description:
 *
 * Copyright (c) 2022 by zhoufei, All Rights Reserved.
 */
package utils

import (
	"fmt"
	"testing"

	jsoniter "github.com/json-iterator/go"
	"github.com/stretchr/testify/assert"
)

func TestSome(t *testing.T) {
	v := 20
	assert.Equal(t, ttt(v), int64(200000))
}

func ttt(a interface{}) int64 {
	return int64(a.(int) * 10000)
}

var jsonIterator = jsoniter.ConfigCompatibleWithStandardLibrary

func TestJson(t *testing.T) {
	json := `{"a":20,"b":20.6,"c":"123","d":111.2,"e":9999}`

	var st map[string]interface{}
	err := jsonIterator.Unmarshal([]byte(json), &st)
	if err != nil {
		t.Fatal(err)
	}

	for _, v := range st {
		if vv, ok := v.(float64); ok {
			fmt.Println(int64(vv * 10000))
		}
	}
	fmt.Println(st)
}
