/*
 * @Author: zhoufei
 * @Date: 2022-03-15 18:26:05
 * @LastEditors: zhoufei
 * @LastEditTime: 2022-06-02 09:26:34
 * @FilePath: /utils/strconv.go
 * @Description:
 *
 * Copyright (c) 2022 by zhoufei, All Rights Reserved.
 */
package utils

import (
	"fmt"
	"math"
	"strconv"
)

// int to string
func IntToString(a int) string {
	return strconv.Itoa(a)
}

// float64 to string
func Float64ToString(a float64, point int) string {
	a = FloatRound(a, point)
	return strconv.FormatFloat(a, 'f', -1, 64)
}

// string to int
func StringToInt(s string) int {
	i, _ := strconv.Atoi(s)
	return i
}

// string to float64
func StringToFloat64(s string) float64 {
	f, _ := strconv.ParseFloat(s, 64)
	return f
}

// float round point
func FloatRound(f float64, n int) float64 {
	format := "%." + strconv.Itoa(n) + "f"
	res, _ := strconv.ParseFloat(fmt.Sprintf(format, f), 64)
	return res
}

// 小数四舍五入到整型
func FloatRoundUp(f float64) int {
	return int(math.Ceil(f - 0.5))
}
